define(['angular', 'app'], function (angular, app) {
	"use strict";
	app.service("escapeService", function () {
		var escapeService = {};

		escapeService.escape = function(str) {
			if(typeof str === "string") {
				str = str.replace(/&/g, "&amp;");
				str = str.replace(/>/g, "&gt;");
				str = str.replace(/</g, "&lt;");
				str = str.replace(/"/g, "&quot;");
				str = str.replace(/'/g, "&#x27;");
				str = str.replace(/\//g, "&#x2F;");
			}
			return str;
		}

		escapeService.unescape = function(str) {
			if(typeof str === "string") {
				str = str.replace(/&amp;/g, "&");
				str = str.replace(/&gt;/g, ">");
				str = str.replace(/&lt;/g, "<");
				str = str.replace(/&quot;/g, '"');
				str = str.replace(/&#x27;/g, "'");
				str = str.replace(/&#x2F;/g, "/");
			}
			return str;
		}

		return escapeService;
	});
});